/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WeakValueHashMap
extends HashMap {
    public void clearRefs() {
        Map.Entry entry = null;
        Iterator i = super.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            if (((Reference)entry.getValue()).get() != null) continue;
            i.remove();
        }
    }

    public boolean isEmpty() {
        this.clearRefs();
        return super.isEmpty();
    }

    public boolean containsValue(Object value) {
        Object val = null;
        Map.Entry entry = null;
        Iterator i = super.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            val = ((Reference)entry.getValue()).get();
            if (val == null) {
                i.remove();
                continue;
            }
            if (!val.equals(value)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        this.clearRefs();
        return super.size();
    }

    public Object put(Object key, Object value) {
        return super.put(key, new WeakReference<Object>(value));
    }

    public boolean containsKey(Object key) {
        this.clearRefs();
        return super.containsKey(key);
    }

    public Object get(Object key) {
        Reference ref = (Reference)super.get(key);
        return ref == null ? null : ref.get();
    }

    public void clear() {
        super.clear();
    }

    public Object clone() {
        this.clearRefs();
        return super.clone();
    }

    public Object remove(Object key) {
        Reference ref = (Reference)super.remove(key);
        if (ref != null) {
            return ref.get();
        }
        return null;
    }

    public void putAll(Map t) {
        this.clearRefs();
        Iterator i = t.entrySet().iterator();
        Map.Entry entry = null;
        while (i.hasNext()) {
            entry = i.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Set keySet() {
        this.clearRefs();
        return super.keySet();
    }

    public Collection values() {
        this.clearRefs();
        return super.values();
    }

    public Set entrySet() {
        this.clearRefs();
        return super.entrySet();
    }

    public String toString() {
        this.clearRefs();
        StringBuffer buff = new StringBuffer("{");
        Map.Entry entry = null;
        Object value = null;
        String valueString = null;
        Iterator i = super.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            value = ((Reference)entry.getValue()).get();
            valueString = value == null ? "null" : value.toString();
            buff.append(entry.getKey().toString());
            buff.append("=");
            buff.append(valueString);
            if (!i.hasNext()) continue;
            buff.append(", ");
        }
        buff.append("}");
        return buff.toString();
    }

    public boolean equals(Object o) {
        this.clearRefs();
        return super.equals(o);
    }

    public int hashCode() {
        this.clearRefs();
        return super.hashCode();
    }
}

